VERSION 5.00
Begin VB.Form SetDesignDensity 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Set Design Density"
   ClientHeight    =   1965
   ClientLeft      =   2760
   ClientTop       =   3750
   ClientWidth     =   5265
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   1965
   ScaleWidth      =   5265
   ShowInTaskbar   =   0   'False
   Begin VB.Frame Frame1 
      Caption         =   "Density"
      Height          =   1815
      Left            =   120
      TabIndex        =   2
      Top             =   0
      Width           =   3735
      Begin VB.ComboBox cmbMaterials 
         Height          =   315
         Left            =   240
         Style           =   2  'Dropdown List
         TabIndex        =   4
         Top             =   720
         Width           =   3255
      End
      Begin VB.Label lblUnits 
         Caption         =   "Label2"
         Height          =   255
         Left            =   1800
         TabIndex        =   6
         Top             =   1320
         Width           =   1335
      End
      Begin VB.Label lblValue 
         Caption         =   "Label1"
         Height          =   255
         Left            =   360
         TabIndex        =   5
         Top             =   1320
         Width           =   1215
      End
      Begin VB.Label lblMaterial 
         Caption         =   "Material"
         Height          =   255
         Left            =   240
         TabIndex        =   3
         Top             =   360
         Width           =   2655
      End
   End
   Begin VB.CommandButton CancelButton 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   3960
      TabIndex        =   1
      Top             =   600
      Width           =   1215
   End
   Begin VB.CommandButton OKButton 
      Caption         =   "OK"
      Height          =   375
      Left            =   3960
      TabIndex        =   0
      Top             =   120
      Width           =   1215
   End
End
Attribute VB_Name = "SetDesignDensity"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const wantDebug As Boolean = False

Private Sub cmbMaterials_Change()
    'set value and units
    'hard code to kg m-3 for now
    Dim material As String
    material = cmbMaterials.text
    lblValue.Caption = LoadResString(150) & GetDensity(material)
    
End Sub

Private Sub CancelButton_Click()
    Unload Me
End Sub

Private Sub OKButton_Click()
    Dim matString As String
    matString = cmbMaterials.text
    
    Dim material As String, i As Integer
    i = InStr(1, matString, " ", vbTextCompare)
    material = Trim(Left$(matString, i))
    
    Dim density As Double
    density = CDbl(GetDensity(matString))
    
    SetDensityVariable material, density
    
    Unload Me
End Sub

Private Sub Form_Initialize()
    'initialize dialog strings
    Me.Caption = LoadResString(151)
    Frame1.Caption = LoadResString(147)
    lblMaterial.Caption = LoadResString(148)
    lblUnits.Caption = LoadResString(149)       '"kg m[-3]" - hard code bandit... remember to change if you start swapping units
    lblValue.Caption = LoadResString(150)
    'buttons
    OKButton.Caption = LoadResString(143)
    CancelButton.Caption = LoadResString(144)
    
    'combo box
    'cmbMaterials.Style = fmStyleDropDownList        'vbComboDrop-DownList ?? can only be set at design time in VB
    
    'temp for now... hard code material/density...fix later
    cmbMaterials.AddItem "Steel 7800", 0
    cmbMaterials.AddItem "Aluminium 2700", 1
    cmbMaterials.AddItem "Plastic 1800", 2
    cmbMaterials.AddItem "Water 1000", 3
    cmbMaterials.AddItem "Brass 8900", 4
    cmbMaterials.AddItem "Bonze 9000", 5
    cmbMaterials.AddItem "Lead 11350", 6
    cmbMaterials.AddItem "Stainless_Steel 8450", 7
    cmbMaterials.AddItem "Cast_Iron  7870", 8
    cmbMaterials.AddItem "Glass 2500", 9
    cmbMaterials.AddItem "Rubber 1200", 10
    cmbMaterials.AddItem "Cork 150", 11
    cmbMaterials.AddItem "Teflon 2200", 12
    cmbMaterials.AddItem "Nylon 1160", 13
    cmbMaterials.AddItem "Zinc 7150", 14
    cmbMaterials.AddItem "Tin 7310", 15
    cmbMaterials.AddItem "Tungsten 19300", 16
    cmbMaterials.AddItem "Magnesium 1740", 17
    cmbMaterials.AddItem "Copper 8970", 18
    cmbMaterials.AddItem "Polystyrene 1050", 19

    cmbMaterials.ListIndex = 0
End Sub

Private Function GetDensity(s As String) As String
    Dim i As Integer
    i = InStr(1, s, " ", vbTextCompare)
    GetDensity = Right$(s, Len(s) - i)
End Function

Private Sub SetDensityVariable(material As String, density As Double)
    If wantDebug Then MsgBox material & " " & density
    
    Dim app As ProDESKTOP
    Set app = CreateObject("ProDESKTOP.Application")
    
    Dim api As helm
    Set api = app.TakeHelm
    
    Dim doc As PartDocument, des As aDesign
    Set doc = app.GetActiveDoc
    Set des = doc.GetDesign
    
    des.setDensity density
    
    Dim exp As aExpressionSystem
    Set exp = des.GetExpressionSystem
    
    Dim densityVariable As aVariable
    Set densityVariable = exp.LookupVariable(des, LoadResString(152))
    
    If wantDebug Then MsgBox densityVariable.GetValue.GetUserValue
    
    doc.UpdateDesign
    api.CommitCalls LoadResString(153), False
    
    Dim customProp As aCustomProperty
    Dim zCustomProp As zCustomProperty
    Set customProp = doc.GetCustomProperty
    
    If wantDebug Then MsgBox material
    
    Set zCustomProp = customProp.GetProperty
    Dim ret As Boolean
    Dim m As Variant
    m = material
    ret = zCustomProp.Set(LoadResString(148), m)
    
    customProp.SetProperty zCustomProp
    
    doc.UpdateDesign
    api.CommitCalls LoadResString(153), False
End Sub
